﻿using Newtonsoft.Json;
using System.ComponentModel;

namespace inutralia.Models
{
    /// <summary>
    /// Representa el menú personal guardado localmente
    /// </summary> 
	[JsonObject(MemberSerialization.OptIn)]
    [DataPath("LocalMenu")]
    public class LocalMenu : Menu
    {
        private static JsonSerializerSettings _jsonSettings = new JsonSerializerSettings
        {
            ObjectCreationHandling = ObjectCreationHandling.Replace,
            NullValueHandling = NullValueHandling.Ignore
        };

        /// <summary>
        /// Indice del plato seleccionado para un día
        /// </summary>
        public class MealSelections
        {
            [JsonProperty("lf_idx", DefaultValueHandling = DefaultValueHandling.Populate)]
            [DefaultValue(-1)]
            public int LunchFirstIndex = -1;

            [JsonProperty("ls_idx", DefaultValueHandling = DefaultValueHandling.Populate)]
            [DefaultValue(-1)]
            public int LunchSecondIndex = -1;

            [JsonProperty("df_idx", DefaultValueHandling = DefaultValueHandling.Populate)]
            [DefaultValue(-1)]
            public int DinnerFirstIndex = -1;

            [JsonProperty("ds_idx", DefaultValueHandling = DefaultValueHandling.Populate)]
            [DefaultValue(-1)]
            public int DinnerSecondIndex = -1;
        }

        /// <summary>
        /// Platos seleccionados para cada uno de los días
        /// </summary>
        [JsonProperty("day_selections")]
        public MealSelections[] DaySelections;

        /// <summary>
        /// Identificador del último menú semanal recibido del servidor
        /// </summary>
        [JsonProperty("last_id")]
        public int LastReceivedMenuId;

        /// <summary>
        /// Copia los datos del menú recibido del servidor
        /// </summary>
        /// <param name="menu">El recibido del servidor</param>
        public void AssignFromMenu(Menu menu)
        {
            // Usar el serializador Json para copiar los datos del menú
            JsonConvert.PopulateObject(JsonConvert.SerializeObject(menu), this, _jsonSettings);

            // Borrar la selección de los platos de cada día
            DaySelections = new MealSelections[7];
            for (int i = 0; i < 7; i++)
                DaySelections[i] = new MealSelections();

            // Asignar último menú recibido
            LastReceivedMenuId = menu.Id;
        }
    }
}
