﻿using Newtonsoft.Json;
using System.ComponentModel;

namespace inutralia.Models
{
    [JsonObject(MemberSerialization.OptIn)]
    [DataPath("profile")]
    public class Profile : ObservableEntityData
    {
        [JsonProperty("code")]
        [DefaultValue("")]
        public string Code { get; set; }

        [JsonProperty("age")]
        [DefaultValue(0)]
        public int Age { get; set; }

        [JsonProperty("gender")]
        [DefaultValue('M')]
        public char Gender { get; set; }

        [JsonProperty("height")]
        [DefaultValue(0)]
        public int Height { get; set; }

        [JsonProperty("weight")]
        [DefaultValue(0)]
        public int Weight { get; set; }

        [JsonProperty("physical")]
        [DefaultValue(0)]
        public int Physical { get; set; }

        [JsonProperty("menopause")]
        [JsonConverter(typeof(BoolConverter))]
        [DefaultValue("0")]
        public bool Menopause { get; set; }

        [JsonProperty("pregnancy")]
        [JsonConverter(typeof(BoolConverter))]
        [DefaultValue("0")]
        public bool Pregnancy { get; set; }

        [JsonProperty("lactation")]
        [JsonConverter(typeof(BoolConverter))]
        [DefaultValue("0")]
        public bool Lactation { get; set; }

        [JsonProperty("celiac")]
        [JsonConverter(typeof(BoolConverter))]
        [DefaultValue("0")]
        public bool Celiac { get; set; }

        [JsonProperty("lactose")]
        [JsonConverter(typeof(BoolConverter))]
        [DefaultValue("0")]
        public bool Lactose { get; set; }

        [JsonProperty("diabetes")]
        [JsonConverter(typeof(BoolConverter))]
        [DefaultValue("0")]
        public bool Diabetes { get; set; }

        [JsonProperty("cholesterol")]
        [JsonConverter(typeof(BoolConverter))]
        [DefaultValue("0")]
        public bool Cholesterol { get; set; }

        [JsonProperty("hypertension")]
        [JsonConverter(typeof(BoolConverter))]
        [DefaultValue("0")]
        public bool Hypertension { get; set; }

        [JsonProperty("triglycerides")]
        [JsonConverter(typeof(BoolConverter))]
        [DefaultValue("0")]
        public bool Triglycerides { get; set; }

        [JsonProperty("cv")]
        [JsonConverter(typeof(BoolConverter))]
        [DefaultValue("0")]
        public bool Cv { get; set; }

        [JsonProperty("al_fish")]
        [JsonConverter(typeof(BoolConverter))]
        [DefaultValue("0")]
        public bool Al_fish { get; set; }

        [JsonProperty("al_egg")]
        [JsonConverter(typeof(BoolConverter))]
        [DefaultValue("0")]
        public bool Al_egg { get; set; }

        [JsonProperty("al_nuts")]
        [JsonConverter(typeof(BoolConverter))]
        [DefaultValue("0")]
        public bool Al_nuts { get; set; }

        [JsonProperty("preference")]
        [DefaultValue(0)]
        public int Preference { get; set; }

        public Profile() { }
    }
}
