﻿using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.Collections.Generic;

namespace inutralia.Models
{
    [JsonObject(MemberSerialization.OptIn)]
    [DataPath("questionList")]

    public class QuestionSpecialist : ObservableEntityData
    {
        public QuestionSpecialist()
        {
            State = 0;
        }

        public enum Estatus { Pending, Answered }

        public string StatusImg => imgStatus[StateId];

        [JsonProperty("estado_id", Required = Required.Always)]
        public int StateId { get; set; }

        [JsonProperty("status", Required = Required.Always)]
        [JsonConverter(typeof(StringEnumConverter))]
        public Estatus State { get; set; }

        [JsonProperty("updated_at", Required = Required.Always)]
        public int UpdatedAt { get; set; }

        [JsonProperty("messages", Required = Required.Always)]
        public IEnumerable<QuestionMessage> Messages { get; set; }

        string[] imgStatus = new string[2]
        {
            "message_status_pendiente.png",  // 1 - Pendiente de responder
            "message_status_respondido.png", // 2 - Respondida
        };
    }
}