﻿using Newtonsoft.Json;
using System.Collections.Generic;

namespace inutralia.Models
{
    [JsonObject(MemberSerialization.OptIn)]
    [DataPath("recipe")]

    public class Recipe : ObservableEntityData
    {
        [JsonProperty("name", Required = Required.Always)]
        public string Name { get; set; }

        [JsonProperty("shortName")]
        public string ShortName { get; set; }

        [JsonProperty("excerpt")]
        public string Excerpt { get; set; }

        [JsonProperty("description")]
        public string Description { get; set; }

        [JsonProperty("image")]
        public string Image { get; set; }

        [JsonProperty("time")]
        public int Time { get; set; }

        [JsonProperty("difficulty")]
        public string Difficulty { get; set; }

        [JsonProperty("energy")]
        public string Energy { get; set; }

        [JsonProperty("protein")]
        public string Protein { get; set; }

        [JsonProperty("carbohydrates")]
        public string Carbohydrates { get; set; }

        [JsonProperty("lipids")]
        public string Lipids { get; set; }

        [JsonProperty("fiber")]
        public string Fiber { get; set; }

        [JsonProperty("cholesterol")]
        public string Cholesterol { get; set; }

        [JsonProperty("ingredients")]
        public IList<Ingredient> Ingredients { get; set; }

        public string ExcerptQuotes => $"\"{Excerpt}\"";

        public Recipe() { }
    }
}
