using Xamarin.Forms;

namespace inutralia
{
    public partial class CustomActivityIndicator : ContentView
    {
        public CustomActivityIndicator()
        {
            InitializeComponent();
            SpinY(Wrapper, 1000);
        }

        static void SpinY(View child, uint duration)
        {
            var animation = new Animation(
                callback: d => child.RotationY = d,
                start: 0,
                end: 360,
                easing: Easing.Linear);

            animation.Commit(child, "Loop", length: duration, repeat: () => true);
        }
    }
}

