﻿using inutralia.ViewModels;
using Xamarin.Forms;
using Xamarin.Forms.Xaml;

namespace inutralia.Views.Question
{
    [XamlCompilation(XamlCompilationOptions.Compile)]
    public partial class HistoryView : ContentPage
    {
        protected QuestionListViewModel ViewModel => BindingContext as QuestionListViewModel;

        public HistoryView()
        {
            InitializeComponent();
            BindingContext = new QuestionListViewModel();
        }

        protected override async void OnAppearing()
        {
            base.OnAppearing();
            await ViewModel.ExecuteLoadQuestionListCommand();
        }

        void ItemTapped(object sender, ItemTappedEventArgs e)
        {
            ((ListView)sender).SelectedItem = null;
        }
    }
}