﻿using inutralia.ViewModels;
using System;
using Xamarin.Forms;
using Xamarin.Forms.Xaml;

namespace inutralia.Views
{
    [XamlCompilation(XamlCompilationOptions.Compile)]
    public partial class ListDelSuper : ContentPage
    {
        protected ShoppingListViewModel ViewModel => BindingContext as ShoppingListViewModel;

        public ListDelSuper()
        {
            InitializeComponent();
        }

        void ItemTapped(object sender, ItemTappedEventArgs e)
        {
            ((ListView)sender).SelectedItem = null;
        }

        private void BuyModalButton(object sender, WebNavigatingEventArgs e)
        {
            var browser = API.Constants.ApiUrl;

            foreach (var element in ViewModel.ShoppingList)
            {
                browser += element.Id.ToString() + ',';
            }

            browser = browser.TrimEnd(',');
            Device.OpenUri(new Uri(browser));
        }

        async void CancelModalButton(object sender, EventArgs e)
        {
            await Navigation.PopAsync();
        }

        protected override async void OnAppearing()
        {
            base.OnAppearing();
            await ViewModel.ExecuteLoadShoppingListCommand();
        }
    }
}
