﻿using inutralia.ViewModels;
using System;
using Xamarin.Forms;

namespace inutralia.Views
{
    public partial class ModalAddShoppingList : ContentPage
    {
        protected ShoppingListViewModel ViewModel => BindingContext as ShoppingListViewModel;

        public ModalAddShoppingList()
        {
            InitializeComponent();
            entryIngre.TextChanged += AddIngreTextChanged;
            entryIngre.Text = "";
            entryIngre.IsEnabled = true;
        }

        private void AddIngreTextChanged(object sender, TextChangedEventArgs e)
        {
            addModalButton.IsVisible = (entryIngre.Text.Length > 0);
        }

        private async void AddModalButton(object sender, EventArgs e)
        {
            var newItem = new Models.ShoppingList() { FromMenus = false, Select = false, Text = entryIngre.Text };
            await ViewModel.AddItem(newItem);
            await Navigation.PopModalAsync();
        }

        async void CancelModalButton(object sender, EventArgs e)
        {
            await Navigation.PopModalAsync();
        }

        protected override void OnAppearing()
        {
            base.OnAppearing();
        }
    }
}


