﻿namespace inutralia.ViewModels
{
    using inutralia.Models;
    using System.Threading.Tasks;

    public class RecipeViewModel : BaseNavigationViewModel
    {
        public RecipeViewModel(Recipe recipe)
        {
            Recipe = recipe;
            Title = Recipe.Name;
            if (Recipe.Ingredients == null)
                Recipe.Ingredients = new Ingredient[0];
        }

        public Recipe Recipe { get; private set; }

        public async Task RefreshData()
        {
            if (Recipe == null)
                return;

            IsBusy = true;

            if (await App.API.RefreshItemAsync(Recipe))
            {
                OnPropertyChanged("Recipe");

                // Cambiar título
                Title = Recipe.Name;
            } //endif

            IsBusy = false;
        }
    }
}
