﻿namespace inutralia.Views.Question
{
    using inutralia.Models.Questions;
    using inutralia.ViewModels;
    using Xamarin.Forms;
    using Xamarin.Forms.Xaml;

    [XamlCompilation(XamlCompilationOptions.Compile)]
    public partial class HistoryView : ContentPage
    {
        protected QuestionListViewModel ViewModel => BindingContext as QuestionListViewModel;

        public HistoryView()
        {
            InitializeComponent();
            BindingContext = new QuestionListViewModel();
        }

        protected async void ItemTapped(object sender, ItemTappedEventArgs e)
        {
            var respon = e.Item as Message;
            if (respon.StatusImg == "Respondida")
            {
                await DisplayAlert("ERROR", "La pregunta ya está respondida", "Entendido");
            }
            else
            {
                await Navigation.PushAsync(
                    new PendingReadView()
                    {
                        BindingContext = new PendingReadViewModel((Message)e.Item)
                    }
            );
                ((ListView)sender).SelectedItem = null;
            }
        }

        protected override async void OnAppearing()
        {
            base.OnAppearing();
            await ViewModel.ExecuteLoadQuestionListCommand();
        }
    }
}