﻿namespace inutralia.Views.Question
{
    using inutralia.ViewModels;
    using Xamarin.Forms;
    using Xamarin.Forms.Xaml;

    [XamlCompilation(XamlCompilationOptions.Compile)]
    public partial class NewConsultationView : ContentPage
    {
        protected NewQuestionViewModel ViewModel => BindingContext as NewQuestionViewModel;

        NewQuestionViewModel vm;

        public NewConsultationView()
        {
            InitializeComponent();

            BindingContext = vm = new NewQuestionViewModel();

            vm.ListMessages.CollectionChanged += (sender, e) =>
            {
                var target = vm.ListMessages[vm.ListMessages.Count - 1];
                MessagesListView.ScrollTo(target, ScrollToPosition.End, true);
            };
        }

        protected void ItemTapped(object sender, ItemTappedEventArgs e)
        {
            ((ListView)sender).SelectedItem = null;
        }

        protected async override void OnAppearing()
        {
            base.OnAppearing();
            await ViewModel.RefreshData();
        }
    }
}