﻿namespace inutralia.Views.Question
{
    using inutralia.Models.Questions;
    using inutralia.ViewModels;
    using Xamarin.Forms;
    using Xamarin.Forms.Xaml;

    [XamlCompilation(XamlCompilationOptions.Compile)]
    public partial class PendingReadView : ContentPage
    {
        protected PendingReadViewModel ViewModel => BindingContext as PendingReadViewModel;

        public Message Message { private set; get; }

        public PendingReadView()
        {
            InitializeComponent();
            BindingContext = new PendingReadViewModel();
        }

        protected async void ItemTapped(object sender, ItemTappedEventArgs e)
        {
            await Navigation.PushAsync(new NewConsultationView()
            {
                BindingContext = ViewModel.Message
            });

            ((ListView)sender).SelectedItem = null;
        }

        protected override async void OnAppearing()
        {
            base.OnAppearing();
            await ViewModel.RefreshData();
        }
    }
}