namespace inutralia.Views
{
    using System;
    using System.Net;
    using Xamarin.Forms;

    public partial class RegisterView : ContentPage
    {
        public RegisterView()
        {
            InitializeComponent();
        }

        async void OnRegisterButtonClicked(object sender, EventArgs e)
        {
            var companyCode = companyCodeEntry.Text;
            var userName = userNameEntry.Text;
            var passWord = passWordEntry.Text;

            HttpStatusCode? errorCode = await App.API.RegisterUser(companyCode, userName, passWord);

            if (errorCode == null)
            {
                await DisplayAlert("Correcto", "Se ha registrado correctamente. Puede acceder a la aplicación.", "Entendido");
                // Cambiar de vista
                await Navigation.PopModalAsync();
            }

            else
            {
                string msg = (errorCode == HttpStatusCode.Conflict) ?
                    "Ya existe un usuario con ese nombre, pruebe con otro." :
                    "Se ha producido un error en la grabación, por favor, inténtelo más tarde.";

                await DisplayAlert("Error", msg, "Entendido");
            } //endif
        }

        async void OnBackButtonClicked(object sender, EventArgs e)
        {
            await Navigation.PopModalAsync();
        }

        private void ConditionsSwitch_Toggled(object sender, ToggledEventArgs e)
        {
            RegisterButton.IsEnabled = e.Value;
        }

        private async void ConditionsLabelTapped(object sender, EventArgs e)
        {
            // Vista con las condiciones legales
            await Navigation.PushModalAsync(new RegisterConditionsView() as Page);
        }
    }
}
