﻿namespace inutralia.Views
{
    using inutralia.ViewModels;
    using inutralia.Views.ShoppingList;
    using System;
    using Xamarin.Forms;

    public partial class ShoppingListView : ContentPage
    {
        protected ShoppingListViewModel ViewModel => BindingContext as ShoppingListViewModel;

        public ShoppingListView()
        {
            InitializeComponent();
            BindingContext = new ShoppingListViewModel();
        }

        protected override async void OnAppearing()
        {
            base.OnAppearing();
            await ViewModel.ExecuteLoadShoppingListCommand();
        }

        void ItemTapped(object sender, ItemTappedEventArgs e)
        {
            ((ListView)sender).SelectedItem = null;
        }

        private async void InfoButtonClicked(object sender, EventArgs e)
        {
            await Navigation.PushAsync(new InfoPopup());
        }

        async void OnAddButtonClicked(object sender, EventArgs e)
        {
            var addingre = new ModalAddShoppingList()
            {
                BindingContext = ViewModel
            };
            await Navigation.PushModalAsync(addingre);
        }

        async void OnAddDelSuperButtonClicked(object sender, EventArgs e)
        {
            var buy = new ListDelSuper()
            {
                BindingContext = ViewModel
            };
            await Navigation.PushAsync(buy);
        }

        async void OnDeleteButtonClicked(object sender, EventArgs e)
        {
            if (await DisplayAlert("Está a punto de borrar uno o varios ingredientes.", "¿Desea continuar?", "Aceptar", "Cancelar"))
            {
                await ViewModel.DeleteSelected();
            }
        }

        async void OnDeleteAllButtonClicked(object sender, EventArgs e)
        {
            if (await DisplayAlert("Está a punto de borrar todos los ingredientes.", "¿Desea continuar?", "Aceptar", "Cancelar"))
            {
                await ViewModel.DeleteAll();
            }
        }
    }
}

