using Android.App;
using Android.Content.PM;
using Android.Views;
using Android.OS;
using Xamarin.Forms.Platform.Android;
using Xamarin.Forms;
using UXDivers.Artina.Shared;
using UXDivers.Artina.Shared.Droid;
using FFImageLoading.Forms.Droid;

namespace inutralia
{
    //https://developer.android.com/guide/topics/manifest/activity-element.html
    [Activity(
        Label = "iNutralia",
        Icon = "@drawable/icon",
        Theme = "@style/Theme.Splash",
         MainLauncher = true,
        LaunchMode = LaunchMode.SingleTask,
        ConfigurationChanges = ConfigChanges.Orientation | ConfigChanges.ScreenSize,
        ScreenOrientation = ScreenOrientation.Portrait
        )
    ]
    public class MainActivity : FormsAppCompatActivity
    {
        protected override void OnCreate(Bundle bundle)
        {
            // Changing to App's theme since we are OnCreate and we are ready to 
            // "hide" the splash
            base.Window.RequestFeature(WindowFeatures.ActionBar);
            base.SetTheme(Resource.Style.AppTheme);

            FormsAppCompatActivity.ToolbarResource = Resource.Layout.Toolbar;
            FormsAppCompatActivity.TabLayoutResource = Resource.Layout.Tabs;

            base.OnCreate(bundle);

            Window.AddFlags(WindowManagerFlags.Fullscreen);

            //Initializing FFImageLoading
            FFImageLoading.Forms.Platform.CachedImageRenderer.Init(true);

            Forms.Init(this, bundle);

            //Initializing GrialKit
            GrialKit.Init(this, "inutralia.GrialLicense");

            FormsHelper.ForceLoadingAssemblyContainingType(typeof(UXDivers.Effects.Effects));

            LoadApplication(new App());
        }

        public override void OnConfigurationChanged(Android.Content.Res.Configuration newConfig)
        {
            base.OnConfigurationChanged(newConfig);

            DeviceOrientationLocator.NotifyOrientationChanged();
        }

        public override void OnBackPressed()
        {
            var md = Xamarin.Forms.Application.Current.MainPage as MasterDetailPage;

            if (md != null && !md.IsPresented &&
                (
                !(md.Detail is NavigationPage) || (((NavigationPage)md.Detail).Navigation.NavigationStack.Count == 1 && ((NavigationPage)md.Detail).Navigation.ModalStack.Count == 0)
                ))
                MoveTaskToBack(true);
            else
                base.OnBackPressed();
        }
    }
}

