﻿using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using System.Collections.Generic;

namespace inutralia.Models
{
    [JsonObject(MemberSerialization.OptIn)]
    [DataPath("questionList")]

    public class QuestionSpecialist : ObservableEntityData
    {
        public QuestionSpecialist(string subject)
        {
            Subject = subject;
            State = 0;

            List<QuestionMessage> msgs = new List<QuestionMessage>();
            Messages = msgs;
        }

        public enum Estatus { Pending, Answered_for_client, Answered_for_nutricionist, Closed }

        public string StatusImg => imgStatus[StateId];

        [JsonProperty("state_id", Required = Required.Always)]
        public int StateId { get; set; }

        [JsonProperty("status", Required = Required.Always)]
        [JsonConverter(typeof(StringEnumConverter))]
        public Estatus State { get; set; }

        [JsonProperty("subject", Required = Required.Always)]
        public string Subject { get; set; }   

        [JsonProperty("message", Required = Required.Always)]
        public IEnumerable<QuestionMessage> Messages { get; set; }

        string[] imgStatus = new string[2]
        {
            "pendiente.png",  // 1 - Pendiente de responder
            //"respondida_por_cliente.png", // 2 - Respondida por cliente
            //"respondida_por_nutricionista", // 3- Respondida por nutricionista
            "cerrada" // 4 - Conversación cerrada
        };
    }
}