﻿using Newtonsoft.Json;
using System.Collections.Generic;

namespace inutralia.Models
{
    [JsonObject(MemberSerialization.OptIn)]
    [DataPath("options")]

    public class RecipeOptionGroup : ObservableEntityData
    {
        private bool _isExpanded = false;

        public bool IsExpanded
        {
            get
            {
                return _isExpanded;
            }
            set
            {
                _isExpanded = value;
                OnPropertyChanged();
            }
        }

        [JsonProperty("name", Required = Required.Always)]
        public string Name { get; set; }

        [JsonProperty("options")]
        public IList<RecipeOption> Options { get; set; }
    }
}
