﻿using inutralia.Abstractions;
using MvvmHelpers;
using Newtonsoft.Json;

namespace inutralia.Models
{
    /// <summary>
    /// A type that fulfills IIdentifiableEntity and is also observable 
    /// </summary>
    public class ObservableEntityData : ObservableObject, IIdentifiableEntity
    {
        public ObservableEntityData()
        {
            // Los identificadores negativos indican que la entidad es nueva y no
            // existe por tanto en la base de datos
            Id = -1;
        }

        [JsonProperty("id", Required = Required.Always)]
        public int Id { get; set; }
    }
}
