﻿using System;
using System.Globalization;

namespace inutralia.Utils
{
    public static class DateUtilities
    {
        public static DateTime DateTimefromTimeStamp(int timestamp)
        {
            DateTime dtDateTime = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
            dtDateTime = dtDateTime.AddSeconds(timestamp);
            return dtDateTime;
        }

        public static string formatedDateFromTimeStamp(int timestamp, string format = "dd/MM/YYYY")
        {
            DateTime time = DateTimefromTimeStamp(timestamp);
            string d1 = DateTime.UtcNow.ToString("dd/MM/yyyy");
            string d2 = time.ToString("dd/MM/yyyy");
            if (d1 == d2)
            {
                format = "HH:mm";
            }
            return time.ToString(format);
        }

        public static Int32 formatedDateToTimeStamp(string date, string format = "dd/mm/YYYY", CultureInfo CI = null)
        {
            if (CI == null)
            {
                CI = CultureInfo.CurrentCulture;
            }
            return formatedDateToTimeStamp(DateTime.ParseExact(date, format, CI));
        }

        public static Int32 formatedDateToTimeStamp(DateTime date)
        {
            return (Int32)(date.Subtract(new DateTime(1970, 1, 1))).TotalSeconds;
        }
    }
}
