﻿using inutralia.Models;
using System.Threading.Tasks;

namespace inutralia.ViewModels
{
    /// <summary>
    /// ViewModel con task RefreshData
    /// </summary>
    public abstract class ModelBasedViewModel : BaseNavigationViewModel
    {
        public ModelBasedViewModel(ObservableEntityData model)
        {
            Model = model;
        }

        /// <summary>
        /// El modelo asociado
        /// </summary>
        public ObservableEntityData Model { get; private set; }

        /// <summary>
        /// Refresca los datos del modelo asociado
        /// </summary>
        public async Task RefreshData()
        {
            if (Model == null)
                return;

            IsBusy = true;

            if (await App.API.RefreshItemAsync(Model))
            {
                // Informar que el modelo ha cambiado
                OnPropertyChanged("Model");

                // Comportamiento específico de clases hijas
                OnDataRefreshed();
            } //endif

            IsBusy = false;
        }

        /// <summary>
        /// Permite a las clases hijas realizar acciones específicas
        /// </summary>
        protected virtual void OnDataRefreshed() { }
    }
}
