﻿using System.Threading.Tasks;
using inutralia.Models;

namespace inutralia.ViewModels
{
    public class PendingReadViewModel : BaseNavigationViewModel
    {
        public enum Estatus
        {
            Pendiente = 1,
            Respondida_por_cliente = 2,
            Respondida_por_nutricionista = 3,
            Cerrado = 4
        }

        public PendingReadViewModel(QuestionSpecialist questionSpecialist)
        {
            QuestionSpecialist = questionSpecialist;

            Title = QuestionSpecialist?.StatusImg;
        }

        public PendingReadViewModel() { }

        public QuestionSpecialist QuestionSpecialist { private set; get; }

        public int StateId => QuestionSpecialist.StateId;

        public Estatus estatus => (Estatus)QuestionSpecialist?.StateId;

        public async Task RefresData()
        {
            if (QuestionSpecialist == null)
                return;

            IsBusy = true;

            if (await App.API.RefreshItemAsync(QuestionSpecialist))
            {
                Title = QuestionSpecialist.StatusImg;
                OnPropertyChanged("");
            }

            IsBusy = false;
        }
    }
}
