﻿using inutralia.Views.Question;
using Xamarin.Forms;

namespace inutralia.Views
{
    public partial class MenuView : ContentPage
    {
        public MenuView()
        {
            InitializeComponent();

            btnHome.GestureRecognizers.Add(new TapGestureRecognizer
            {
                Command = new Command(() => OnBtnHomeClicked())
            });

            btnLoginOut.GestureRecognizers.Add(new TapGestureRecognizer
            {
                Command = new Command(() => OnLoginOutClicked())
            }); ;

            btnMyMenu.GestureRecognizers.Add(new TapGestureRecognizer
            {
                Command = new Command(() => OnBtnMyMenuClicked())
            }); ;

            btnMyProfile.GestureRecognizers.Add(new TapGestureRecognizer
            {
                Command = new Command(() => OnBtnMyProfileClicked())
            }); ;

            btnRecipeBook.GestureRecognizers.Add(new TapGestureRecognizer
            {
                Command = new Command(() => OnBtnRecipeBookClicked())
            }); ;

            btnShoppingList.GestureRecognizers.Add(new TapGestureRecognizer
            {
                Command = new Command(() => OnBtnShoppingListClicked())
            }); ;

            btnGenericMenus.GestureRecognizers.Add(new TapGestureRecognizer
            {
                Command = new Command(() => OnBtnGenericMenusClicked())
            }); ;

            btnQuestionSpecialist.GestureRecognizers.Add(new TapGestureRecognizer
            {
                Command = new Command(() => OnBtnQuestionSpecialistClicked())
            }); ;
        }

        void OnBtnHomeClicked()
        {
            (App.Current.MainPage as RootPage).Navigate<HomeView>();
        }

        void OnBtnMyMenuClicked()
        {
            (App.Current.MainPage as RootPage).Navigate<CustomMenuView>();
        }

        void OnBtnMyProfileClicked()
        {
            (App.Current.MainPage as RootPage).Navigate<ProfileView>();
        }

        void OnBtnRecipeBookClicked()
        {
            (App.Current.MainPage as RootPage).Navigate<RecipeListView>();
        }

        void OnBtnGenericMenusClicked()
        {
            (App.Current.MainPage as RootPage).Navigate<GenericListView>();
        }

        void OnBtnShoppingListClicked()
        {
            (App.Current.MainPage as RootPage).Navigate<ShoppingListView>();
        }

        void OnBtnQuestionSpecialistClicked()
        {
            (App.Current.MainPage as RootPage).Navigation<QuestionListView>();
        }

        void OnLoginOutClicked()
        {
            App.IsUserLoggedIn = false;
        }
    }
}
