﻿using inutralia.Models;
using inutralia.ViewModels;
using Xamarin.Forms;
using Xamarin.Forms.Xaml;

namespace inutralia.Views.Question
{
    [XamlCompilation(XamlCompilationOptions.Compile)]
    public partial class HistoryView : ContentPage
    {
        protected QuestionListViewModel ViewModel => BindingContext as QuestionListViewModel;

        public HistoryView()
        {
            InitializeComponent();
            BindingContext = new QuestionListViewModel();
        }

        protected async void ItemTapped(object sender, ItemTappedEventArgs e)
        {
            var respon = e.Item as QuestionSpecialist;
            if (respon.StatusImg == "Respondida")
            {
                await DisplayAlert("ERROR", "La pregunta ya está respondida", "Entendido");
            }
            else
            {
                await Navigation.PushAsync(
                    new PendingReadView()
                    {
                        BindingContext = new PendingReadViewModel((QuestionSpecialist)e.Item)
                    }
        );
                ((ListView)sender).SelectedItem = null;
            }
        }

        protected override async void OnAppearing()
        {
            base.OnAppearing();
            await ViewModel.ExecuteLoadQuestionListCommand();
        }
    }
}