﻿using inutralia.ViewModels;
using System;
using Xamarin.Forms;

namespace inutralia.Views
{
    public partial class ModalFiltersRecipe : ContentPage
    {
        protected RecipeListOptionsViewModel ViewModel => BindingContext as RecipeListOptionsViewModel;

        protected RecipeListView ListView;

        public ModalFiltersRecipe(RecipeListView listView)
        {
            InitializeComponent();
            ListView = listView;
        }

        void ItemTapped(object sender, ItemTappedEventArgs e)
        {
            ((ListView)sender).SelectedItem = null;
        }

        private async void ApplyModalButton(object sender, EventArgs e)
        {
            await ListView.ApplyFilters();
        }

        protected override void OnAppearing()
        {
            base.OnAppearing();
            ViewModel.ExecuteLoadOptionsCommand();
        }
    }
}
