﻿using inutralia.Models;
using inutralia.ViewModels;
using System;
using System.Threading.Tasks;
using Xamarin.Forms;

namespace inutralia.Views
{
    public partial class RecipeListView : ContentPage
    {
        protected RecipeListViewModel ViewModel => BindingContext as RecipeListViewModel;

        protected bool firstTime = true;

        protected ModalFiltersRecipe filtersPage = null;

        public RecipeListView()
        {
            InitializeComponent();
            BindingContext = new RecipeListViewModel();
        }

        /// <summary>
        /// Método llamado al hacer tap en un elemento de la lista. Navega a la página de detalle
        /// de la receta seleccionada
        /// </summary>
        /// <param name="sender">La ListView</param>
        /// <param name="e">Argumentos del evento</param>
        void ItemTapped(object sender, ItemTappedEventArgs e)
        {
            // e.Item apunta a la receta seleccionada. A partir de ella se crea su ViewModel
            // y con él se crea la página de detalle y se navega a ella
            Navigation.PushAsync(
               new RecipeDetailView() { BindingContext = new RecipeViewModel(e.Item as Recipe) }
            );
        }

        public async Task ApplyFilters()
        {
            await Navigation.PopAsync();
            ViewModel.Recipes.Clear();
            ViewModel.RefreshRecipesCommand.Execute(BindingContext);
        }

        /// <summary>
        /// Método llamado cada vez que una página pasa a ser visible
        /// </summary>
        protected override async void OnAppearing()
        {
            base.OnAppearing();

            // La primera vez forzamos la aparición del modal de filtrado
            if (firstTime)
            {
                firstTime = false;

                await DoFiltersAsync();
            } //endif
        }

        /// <summary>
        /// Método llamado al pulsar el toolbar 'Filtros'
        /// </summary>
        private async void ToolbarFiltersClicked(object sender, EventArgs e)
        {
            if (ViewModel.IsNotBusy)
                await DoFiltersAsync();
        }

        /// <summary>
        /// Tarea de filtrado. Muestra el modal, espera a que se cierre, y actualiza el listado
        /// </summary>
        protected async Task DoFiltersAsync()
        {
            // Crear la página de filtros si todavía no existe
            if (filtersPage == null)
            {
                filtersPage = new ModalFiltersRecipe(this)
                {
                    BindingContext = ViewModel.Filters
                };
            } //endif

            // Mostrarla
            await Navigation.PushAsync(filtersPage);
        }
    }
}
