﻿namespace inutralia.Models
{
    using Newtonsoft.Json;
    using System;

    [JsonObject(MemberSerialization.OptIn)]
    [DataPath("article")]
    public class Article : ObservableEntityData
    {
        [JsonProperty("title", Required = Required.Always)]
        public string Title { get; set; }

        [JsonProperty("excerpt")]
        public string Excerpt { get; set; }

        [JsonProperty("body")]
        public string Body { get; set; }

        [JsonProperty("photo")]
        public string Photo { get; set; }

        [JsonProperty("published")]
        public string Date { get; set; }

        public string ExcerptCompress => Excerpt == null ? "..." : Excerpt.Substring(0, Math.Min(80, Excerpt.Length)).Length < 80 ? Excerpt : Excerpt.Substring(0, Excerpt.Substring(0, 80).LastIndexOf(" ")) + ((Excerpt.Length > 80) ? "..." : "");
    }
}
