﻿namespace inutralia.Models
{
    using Newtonsoft.Json;
    using System.Collections.Generic;
    using System.ComponentModel;

    [JsonObject(MemberSerialization.OptIn)]
    [DataPath("trivial")]

    public class TrivialQuestion : ObservableEntityData
    {
        [JsonProperty("image", DefaultValueHandling = DefaultValueHandling.Populate)]
        [DefaultValue("")]
        public string Image { get; set; }

        [JsonProperty("text", Required = Required.Always)]
        public string Text { get; set; }

        [JsonProperty("options", Required = Required.Always)]
        public IList<string> Options { get; set; }

        [JsonProperty("valid", Required = Required.Always)]
        public int ValidIndex { get; set; }
    }
}
