﻿namespace inutralia.ViewModels
{
    using inutralia.Models.Questions;
    using MvvmHelpers;
    using System;
    using System.Windows.Input;
    using Xamarin.Forms;

    public class NewQuestionViewModel : BaseViewModel
    {
        public ObservableRangeCollection<Message> ListMessages { get; }
        public ICommand SendCommand { get; set; }

        public NewQuestionViewModel()
        {
            IsBusy = true;

            ListMessages = new ObservableRangeCollection<Message>();

            SendCommand = new Command(() =>
            {
                if (!String.IsNullOrWhiteSpace(OutText))
                {
                    var message = new Message
                    {
                        Text = OutText,
                        IsTextIn = false,
                        MessageDateTime = DateTime.Now
                    };


                    ListMessages.Add(message);
                    OutText = "";
                }

            });

            IsBusy = false;
        }

        public string OutText
        {
            get { return _outText; }
            set { SetProperty(ref _outText, value); }
        }
        string _outText = string.Empty;
    }
}
