﻿namespace inutralia.ViewModels
{
    using System;
    using System.Threading.Tasks;
    using inutralia.Models;
    using inutralia.Models.Questions;

    public class PendingReadViewModel : BaseNavigationViewModel
    {
        public enum Estatus
        {
            Pendiente = 1,
            Respondida_por_cliente = 2,
            Respondida_por_nutricionista = 3,
            Cerrado = 4
        }

        public PendingReadViewModel(Message message)
        {
            Message = message;
            Title = message?.State;
        }

        public PendingReadViewModel() { }

        public Message Message { private set; get; }

        public int StateId => Message.StateId;

        public Estatus State => (Estatus)Message?.StateId;

        public string Subject => Message?.Subject;

        public DateTime MessageDateTime => (DateTime)Message?.MessageDateTime;

        public async Task RefresData()
        {
            if (Message == null)
                return;

            IsBusy = true;

            if (await App.API.RefreshItemAsync(Message))
            {
                Title = Message.State;
                OnPropertyChanged("State");
            }

            IsBusy = false;
        }

        public bool IsClosedOrPending => (State == Estatus.Pendiente ||
                                          State == Estatus.Cerrado ||
                                          State == Estatus.Respondida_por_cliente ||
                                          State == Estatus.Respondida_por_nutricionista);

        public bool MayBeClosed => !IsClosedOrPending;
    }
}
