﻿namespace inutralia.ViewModels
{
    using MvvmHelpers;

    public class RecipeListOptionsViewModel : BaseNavigationViewModel
    {
        public RecipeListOptionsViewModel() { Title = "Filtrado de Recetas"; }

        public string Desc { get; set; }

        ObservableRangeCollection<RecipeOptionGroupViewModel> _Groups;

        public ObservableRangeCollection<RecipeOptionGroupViewModel> Groups
        {
            get { return _Groups ?? (_Groups = new ObservableRangeCollection<RecipeOptionGroupViewModel>()); }
            set { SetProperty(ref _Groups, value); }
        }

        /// <summary>
        /// Método que realiza la carga inicial de las opciones de filtrado
        /// </summary>
        public void ExecuteLoadOptionsCommand()
        {
            // Realiza el proceso de actualización si hay menos de un 
            // elemento en el listado
            if (Groups.Count < 1)
                FetchOptions();
        }

        /// <summary>
        /// Proceso de actualización del listado
        /// </summary>
        void FetchOptions()
        {
            // Indicamos que estamos ocupados (provoca que aparezca el indicador de carga)
            IsBusy = true;

            // Llamada al API para coger el listado (provoca que se actualize la vista del listado)
            // Nota: Al obtener el listado, el controlador Rest del servidor no retorna el cuerpo de
            // la notificación (campo Body)
            try
            {
                var groups = App.FilterOptions;
                var groupList = new ObservableRangeCollection<RecipeOptionGroupViewModel>();
                foreach (var group in groups)
                    groupList.Add(new RecipeOptionGroupViewModel(group));
                Groups = groupList;
            }
            catch (System.Exception e)
            {
                Groups.Clear();
            }

            // Indicamos que ya no estamos ocupados (provoca que desaparezca el indicador de carga)
            IsBusy = false;
        }
    }
}
