﻿namespace inutralia.Views
{
    using System;
    using inutralia.ViewModels;
    using Xamarin.Forms;

    public partial class ProfileView : ContentPage
    {
        protected ProfileViewModel ViewModel => BindingContext as ProfileViewModel;

        public ProfileView()
        {
            InitializeComponent();
            BindingContext = new ProfileViewModel();
        }

        protected override async void OnAppearing()
        {
            try
            {
                await ViewModel.RefreshData();
                base.OnAppearing();
            }

            catch (Exception e) { }
        }

        async void OnSaveButtonClicked(object sender, EventArgs e)
        {
            try
            {
                await ViewModel.saveData();

                await DisplayAlert("Exito", "La grabación se ha realizado correctamente.", "Entendido");

                (App.Current.MainPage as RootPage).Navigate<HomeView>();
            }

            catch (Exception err)
            {
                await DisplayAlert("Error", "Se ha producido un error. Por favbor, intentelo más tarde", "Entendido");
            }
        }
    }
}
