﻿namespace inutralia.Views
{
    using inutralia.ViewModels;
    using System;
    using System.Linq;
    using Xamarin.Forms;

    public partial class RecipeDetailView : ContentPage
    {
        protected RecipeViewModel ViewModel => BindingContext as RecipeViewModel;

        public RecipeDetailView()
        {
            try
            {
                InitializeComponent();
            }

            catch (Exception e) { }
        }
        protected override async void OnAppearing()
        {
            base.OnAppearing();
            await ViewModel.RefreshData();
            outerScrollView.Scrolled += OnScroll;
        }

        public void UnSelectedItem(object sender, EventArgs e)
        {
            ((ListView)listTable).SelectedItem = null;
        }

        protected override void OnDisappearing()
        {
            base.OnDisappearing();
            outerScrollView.Scrolled -= OnScroll;
        }

        public void OnScroll(object sender, ScrolledEventArgs e)
        {
            var imageHeight = img.Height * 2;
            var scrollRegion = layeringGrid.Height - outerScrollView.Height;
            var parallexRegion = imageHeight - outerScrollView.Height;
            var factor = outerScrollView.ScrollY - parallexRegion * (outerScrollView.ScrollY / scrollRegion);

            if (factor < 0)
            {
                factor = 0;
            }

            else
            {
                if (img.TranslationY > img.Height)
                {
                    factor = img.Height;
                }

                else if (img.TranslationY > outerScrollView.ScrollY)
                {
                    img.TranslationY = outerScrollView.ScrollY;
                }
            }

            img.TranslationY = factor;
            img.Opacity = 1 - (factor / imageHeight);
            //headers.Scale = 1 - ( (factor ) / (imageHeight * 2) ) ;
        }

        public void OnMore(object sender, EventArgs e)
        {
            var mi = ((MenuItem)sender);
        }

        public void OnDelete(object sender, EventArgs e)
        {
            var mi = ((MenuItem)sender);
        }

        /// <summary>
        /// Llamado cuando cambia el contexto asociado
        /// </summary>
        protected override void OnBindingContextChanged()
        {
            base.OnBindingContextChanged();

            // Le decimos al ViewModel que queremos ser informados cuando cambie
            // cualquiera de sus propiedades
            ViewModel.PropertyChanged += OnViewModelPropertyChanged;
        }

        /// <summary>
        /// Llamado cuando cambia el valor de una propiedad del ViewModel
        /// </summary>
        private void OnViewModelPropertyChanged(object sender, System.ComponentModel.PropertyChangedEventArgs e)
        {
            // Cuando cambia el índice del día seleccionado, cambiamos el color de los botones
            if (e.PropertyName == "Recipe")
            {
                listTable.HeightRequest = (30 * ViewModel.Recipe.Ingredients.Count());

            } //endif
        }

        public void OnPrimaryActionButtonClicked(object sender, EventArgs e) { }
    }
}

