﻿namespace inutralia.Views
{
    using inutralia.ViewModels;
    using System;
    using Xamarin.Forms;
    using Xamarin.Forms.Xaml;

    [XamlCompilation(XamlCompilationOptions.Compile)]
    public partial class CustomMenuView : ContentPage
    {
        protected CustomMenuViewModel ViewModel => BindingContext as CustomMenuViewModel;

        // Labels para los botónes de los días
        private static readonly string[] DayNames = new[]
        {
            "L", "M", "X", "J", "V", "S", "D"
        };

        // Constructor. Añade los botones de los días
        public CustomMenuView()
        {
            InitializeComponent();
            BindingContext = new CustomMenuViewModel();

            for (int i = 0; i < 7; i++)
            {
                var b = new UXDivers.Artina.Shared.Button
                {
                    Style = Application.Current.Resources["SquaredButtonStyle"] as Style,
                    VerticalOptions = LayoutOptions.FillAndExpand,
                    HorizontalOptions = LayoutOptions.Fill,
                    FontSize = 22,
                    Text = DayNames[i],
                };

                b.Clicked += OnDayClicked;

                buttonList.Children.Add(b, i, 0);
            }
        }

        /// <summary>
        /// Llamado cuando cambia el contexto asociado
        /// </summary>
        protected override void OnBindingContextChanged()
        {
            base.OnBindingContextChanged();

            // Le decimos al ViewModel que queremos ser informados cuando cambie
            // cualquiera de sus propiedades
            ViewModel.PropertyChanged += OnViewModelPropertyChanged;
        }

        /// <summary>
        /// Llamado cuando cambia el valor de una propiedad del ViewModel
        /// </summary>
        private void OnViewModelPropertyChanged(object sender, System.ComponentModel.PropertyChangedEventArgs e)
        {
            // Cuando cambia el índice del día seleccionado, cambiamos el color de los botones
            if (e.PropertyName == "Index")
            {
                // Coger el botón seleccionado
                View but = buttonList.Children[ViewModel.Index] as View;

                // Poner el fondo del seleccionado a ComplementColor y el resto a AccentColor
                foreach (var b in buttonList.Children)
                    b.BackgroundColor = (Color)Application.Current.Resources[b == but ? "ComplementColor" : "BaseTextColor"];
            } //endif
        }

        /// <summary>
        /// Llamado cuando se pulsa un botón de día
        /// </summary>
        private void OnDayClicked(object sender, EventArgs e)
        {
            // Cambiar el índice del día seleccionado al del botón
            ViewModel.Index = buttonList.Children.IndexOf(sender as View);
        }

        /// <summary>
        /// Llamado cuando esta vista se muestra
        /// </summary>
		protected override async void OnAppearing()
        {
            base.OnAppearing();

            // Decirle al ViewModel que refresque sus datos
            await ViewModel.LoadData();
        }

        protected override async void OnDisappearing()
        {
            base.OnDisappearing();

            await ViewModel.UpdateShoppingListAsync();
        }
    }
}
