﻿namespace inutralia.Models.Questions
{
    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;
    using System;

    [JsonObject(MemberSerialization.OptIn)]
    [DataPath("messages")]

    public class Message : ObservableEntityData
    {
        public enum Estatus
        {
            Pendiente,
            Respondida_por_cliente,
            Respondida_por_nutricionista,
            Cerrado
        };

        public string StatusImg => imgStatus[StateId];

        [JsonProperty("text", Required = Required.Always)]
        public string Text
        {
            get { return _text; }
            set { SetProperty(ref _text, value); }
        }
        string _text;


        [JsonProperty("datetime", Required = Required.Always)]
        public DateTime MessageDateTime
        {
            get { return _messageDateTime; }
            set { SetProperty(ref _messageDateTime, value); }
        }

        DateTime _messageDateTime;

        public string TimeDisplay => MessageDateTime.ToLocalTime().ToString();


        [JsonProperty("isText", Required = Required.Always)]
        public bool IsTextIn
        {
            get { return _isTextIn; }
            set { SetProperty(ref _isTextIn, value); }
        }
        bool _isTextIn;


        [JsonProperty("state_id", Required = Required.Always)]
        public int StateId { get; set; }

        [JsonProperty("status", Required = Required.Always)]
        [JsonConverter(typeof(StringEnumConverter))]
        public Estatus State { get; set; }

        [JsonProperty("subject", Required = Required.Always)]
        public string Subject
        {
            get { return _subject; }
            set { SetProperty(ref _subject, value); }
        }
        string _subject;


        string[] imgStatus = new string[4]
        {
            "pendiente.png",  // 1 - Pendiente de responder
            "respondida_por_cliente.png", // 2 - Respondida por cliente
            "respondida_por_nutricionista", // 3- Respondida por nutricionista
            "cerrada" // 4 - Conversación cerrada
        };
    }
}