﻿namespace inutralia.Models
{
    using System;

    /// <summary>
    /// Atributo para establecer la ruta de acceso a un tipo de datos. Si no se incluye
    /// este atributo, se utilizará el nombre de la clase en minúsculas con una 's' al
    /// final
    /// </summary>
    /// 

    [AttributeUsage(AttributeTargets.Class, AllowMultiple = false, Inherited = true)]
    public class DataPathAttribute : Attribute
    {
        public DataPathAttribute(string path)
        {
            DataPath = path;
        }

        public string DataPath { get; private set; }
    }
}
