namespace inutralia
{
    using Foundation;
    using UIKit;
    using Xamarin.Forms;
    using Lottie.Forms.iOS.Renderers;
    using UXDivers.Artina.Shared;

    // The UIApplicationDelegate for the application. This class is responsible for launching the
    // User Interface of the application, as well as listening (and optionally responding) to application events from iOS

    [Register("AppDelegate")]
    public class AppDelegate : Xamarin.Forms.Platform.iOS.FormsApplicationDelegate
    {
        public override bool FinishedLaunching(UIApplication app, NSDictionary options)
        {
            Forms.Init();

            // Initializing FFImageLoading
            FFImageLoading.Forms.Platform.CachedImageRenderer.Init();

            // Initializing Lottie
            AnimationViewRenderer.Init();

            //Initializing GrialKit
            GrialKit.Init(new ThemeColors(), "inutralia.GrialLicense");

            UIApplication.SharedApplication.SetStatusBarHidden(true, true);
            var tint = UIColor.White;
            UIButton.AppearanceWhenContainedIn(typeof(UINavigationBar)).TintColor = tint;

            app.SetStatusBarStyle(UIStatusBarStyle.LightContent, true);

            UINavigationBar.Appearance.TintColor = UIColor.White;

            FormsHelper.ForceLoadingAssemblyContainingType(typeof(UXDivers.Effects.Effects));
            FormsHelper.ForceLoadingAssemblyContainingType<UXDivers.Effects.iOS.CircleEffect>();

            LoadApplication(new App());

            return base.FinishedLaunching(app, options);
        }
    }
}