namespace inutralia
{
    using System;
    using System.Collections.Generic;
    using Xamarin.Forms;
    using inutralia.Views;
    using inutralia.API;
    using inutralia.Models;
    using System.Reflection;
    using System.IO;
    using Newtonsoft.Json;

    public partial class App : Application
	{
		private static bool _IsUserLoggedIn = false;
		public static bool IsUserLoggedIn
		{
			get { return _IsUserLoggedIn; }
			set
			{
				_IsUserLoggedIn = value;

				if (!value)
				{
                    API.Reset ();
                    Current.MainPage = new NavigationPage(new LoginView());
				}
			}
		}

		public static WebService API { get; private set; }
        public static LocalDataService LocalData { get; private set; }

        protected static List<RecipeOptionGroup> _FilterOptions = null;
        public static List<RecipeOptionGroup> FilterOptions =>
            _FilterOptions ?? (_FilterOptions = LoadFilterOptions() );

        private static List<RecipeOptionGroup> LoadFilterOptions ()
        {
            var assembly = typeof (App).GetTypeInfo ().Assembly;
            Stream stream = assembly.GetManifestResourceStream ("inutralia.filterOptions.json");
            List<RecipeOptionGroup> retVal;
            using (var reader = new System.IO.StreamReader (stream))
            {
                var json = reader.ReadToEnd ();
                var serializerSettings = new JsonSerializerSettings { ObjectCreationHandling = ObjectCreationHandling.Replace, NullValueHandling = NullValueHandling.Ignore };
                retVal = JsonConvert.DeserializeObject<List<RecipeOptionGroup>> (json);
            }

            return retVal;
        }

        public App()
		{
			InitializeComponent();

            MainPage = new NavigationPage(new Page(
            ))
            { BarBackgroundColor = Color.FromHex("#FFa2c300"),
                BarTextColor = Color.White};

			API = new WebService();
            LocalData = new LocalDataService ();
            _FilterOptions = LoadFilterOptions ();

			IsUserLoggedIn = false;
		}

		protected override void OnStart()
		{
			// Handle when your app starts
		}

		protected override void OnSleep()
		{
			// Handle when your app sleeps
		}

		protected override void OnResume()
		{
			// Handle when your app resumes
		}
	}
}