﻿namespace inutralia.ViewModels
{
    using inutralia.Models;
    using System.Threading.Tasks;

    public class ProfileViewModel : BaseNavigationViewModel
    {
        public ProfileViewModel() { Profile = new Profile(); }

        public Profile Profile { private set; get; }

        public string Code => Profile?.Code;

        public int Gender
        {
            get { return Profile.Gender == 'H' ? 0 : 1; }
            set { Profile.Gender = value == 0 ? 'H' : 'M'; }
        }

        public int Physical
        {
            get { return Profile.Physical > 0 ? (Profile.Physical - 1) : 0; }
            set { Profile.Physical = value + 1; }
        }

        public int Preference
        {
            get { return Profile.Preference - 1; }
            set { Profile.Preference = value + 1; }
        }

        public async Task RefreshData()
        {
            IsBusy = true;

            if (await App.API.RefreshItemAsync(Profile))
            {
                OnPropertyChanged("Preference");
                OnPropertyChanged("Profile");
                OnPropertyChanged("Physical");
                OnPropertyChanged("Gender");
            }

            IsBusy = false;
        }

        public async Task saveData()
        {
            IsBusy = true;

            await App.API.UpdateItemAsync(Profile);

            IsBusy = false;
        }
    }
}
