﻿namespace inutralia.Views
{
    using inutralia.Models;
    using inutralia.ViewModels;
    using Xamarin.Forms;
    using Xamarin.Forms.Xaml;

    [XamlCompilation(XamlCompilationOptions.Compile)]
    public partial class TrivialListView : ContentPage
    {
        protected TrivialListViewModel ViewModel => BindingContext as TrivialListViewModel;

        public TrivialListView()
        {
            InitializeComponent();
            BindingContext = new TrivialListViewModel();
        }

        /// <summary>
        /// Método llamado cada vez que una página pasa a ser visible
        /// </summary>
        protected override async void OnAppearing()
        {
            base.OnAppearing();

            // Le decimos al ViewModel que realice la primera carga del listado
            await ViewModel.RefreshList();
        }

        /// <summary>
        /// Método llamado al hacer tap en un elemento de la lista. Navega a la página de detalle
        /// de la partida seleccionada
        /// </summary>
        /// <param name="sender">La ListView</param>
        /// <param name="e">Argumentos del evento</param>
        void ItemTapped(object sender, ItemTappedEventArgs e)
        {
            // e.Item apunta a la partida seleccionada. A partir de ella se crea su ViewModel
            // y con él se crea la página de detalle y se navega a ella
            Navigation.PushAsync(
                new TrivialGameView()
                {
                    BindingContext = new TrivialGameViewModel((TrivialGame)e.Item)
                }
            );

            // Deselecciona el item para que no le cambie el color de fondo
            ((ListView)sender).SelectedItem = null;
        }
    }
}
