﻿namespace inutralia.Views
{
    using inutralia.Models;
    using inutralia.ViewModels;
    using Xamarin.Forms;

    public partial class GenericListView : ContentPage
    {
        // Accesor al ViewModel
        protected GenericListViewModel ViewModel => BindingContext as GenericListViewModel;

        public GenericListView()
        {
            InitializeComponent();
            BindingContext = new GenericListViewModel();
        }

        /// <summary>
        /// Método llamado al hacer tap en un elemento de la lista. Navega a la página de detalle
        /// de la notificación seleccionada
        /// </summary>
        /// <param name="sender">La ListView</param>
        /// <param name="e">Argumentos del evento</param>
        void ItemTapped(object sender, ItemTappedEventArgs e)
        {
            // e.Item apunta a la notificación seleccionada. A partir de ella se crea su ViewModel
            // y con él se crea la página de detalle y se navega a ella
            Navigation.PushAsync(
                new GenericDetailView()
                {
                    BindingContext = new GenericDetailViewModel((Generic)e.Item)
                }
            );

            // Deselecciona el item para que no le cambie el color de fondo
            ((ListView)sender).SelectedItem = null;
        }

        /// <summary>
        /// Método llamado cada vez que una página pasa a ser visible
        /// </summary>
        protected override async void OnAppearing()
        {
            base.OnAppearing();

            // Le decimos al ViewModel que realice la primera carga del listado
            await ViewModel.ExecuteLoadGenericsCommand();
        }
    }
}
