<?php

use Orm\Model;

/**
 * SETI Consultyn S.L.
 * www.seticonsultyn.es
 *
 * Copyright(c) 2011-2013
 *
 * @author    SETI Consultyn S.L. <contacto@seticonsultyn.es>
 * @copyright 2011-2013 SETI Consultyn S.L. http://seticonsultyn.com/copyright.txt
 * @license   SETI Consultyn Software License <license.txt>
 * @link      http://seticonsultyn.es
 */

class Model_Ingredient extends Model{

    protected static $_table_name = 'ingredients';

    protected static $_primary_key = array('id');

    protected static $_belongs_to = array(
        'recipe' => array(
            'key_from' => 'recipe_local_id',
            'key_to' => 'id',
            'model_to' => 'Model_Recipe',
            'cascade_delete' => false
        ),
    );

    public static function get_ingredients_week($recipes_ids)
    {
    	return self::query()->where('recipe_local_id', 'in',$recipes_ids)->order_by('used','DESC')->group_by('ingredient_id')->get();
    }


}