<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Luis
 * Date: 16/12/13
 * Time: 20:55
 * To change this template use File | Settings | File Templates.
 */

use Fuel\Core\DB;
use Fuel\Core\Response;
use \Parser\View;
use Auth\Auth;
use Fuel\Core\Input;

class Controller_Boletinsaludable_Index extends \Controller_App{


    public function before(){

         //Se cargan funciones de javascript especificas de esta funcionalidad
        Casset::js('boletinsaludable/index.js');
        parent::before();
    }

    public function action_index(){

        $view = View::forge('boletinsaludable/index.twig');

        //Titulo de la vista
        $view->title = "Boletín saludable";

        //Pasar la leyenda para la info funcionamiento de la página
        $view->leyenda = "En esta pantalla tendrás acceso a los últimos artículos publicados por los dietistas-nutricionistas del equipo de iNutralia. Un boletín saludable para mantenerte al día";

        $view->articles = $this->ws_article_get();
        
        return Response::forge($view);
    }

    public function post_ver(){

        $view = View::forge('boletinsaludable/ver.twig');

        //Titulo de la vista
        $view->title = "Artículo";

        // El form de la vista no pasa un objeto articulo como cadena de texto separada por |.
        $article = explode('|',Input::post('article'));

        $view->article_title = $article[1];
        $view->article_excerpt = $article[3];
        $view->article_body = $article[2];
        $view->article_published_at = $article[5];
        $view->article_highlight_photo = $article[4];



        return Response::forge($view);
    }


}