<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Luis
 * Date: 16/12/13
 * Time: 20:55
 * To change this template use File | Settings | File Templates.
 */

use Fuel\Core\DB;
use Fuel\Core\Response;
use \Parser\View;
use Auth\Auth;

class Controller_Listacompra_Index extends \Controller_App{

    //Variable para guardar las migas de pan que van a aparecer en las vistas
    private $_bc = array();

    //Array con los elementos del menu que se deben marcar con la clase "active" para que esten seleccionados en el menu.
    private $_option_menu=array('Lista de la compra');

    public function before()
    {
    	$recipes = Model_Recipe::get_recipes_current_week();

	    //PEDIR INGREDIENTES
	    //Recorremos las recetas para obtener los ingredientes.
	    //**AVISO: Si ya se han cargado los ingredientes de una de las recetas, no se vuelve a pedir. Por lo tanto si algo cambia esa semana, no se cambiarán.
	    foreach ($recipes as $recipe)
	    {
			$recipe->load_ingredients();
		}

        parent::before();
    }

    public function action_index(){

        $view = View::forge('listacompra/index.twig');

	    $recipes = Model_Recipe::get_recipes_current_week();

	    $recipe_ids = array();

	    foreach ($recipes as $recipe)
	    {
	    	$recipe_ids[] = $recipe->id;
	    }

	    $view->ingredients = count($recipe_ids)>0 ? Model_Ingredient::get_ingredients_week($recipe_ids) : array();

        //Titulo de la vista
        $view->title = "Lista de la Compra";

        //Paso de las migas de pan a la vista
        $view->bc = $this->_bc;

        //Paso de las opciones de menu que deben aparecer seleccionadas
        $view->option_menu = $this->_option_menu;

        //Pasar la leyenda para la info funcionamiento de la página
        $view->leyenda = "En esta pantalla se han cargado todos los ingredientes necesarios para realizar el menú personalizado que has elegido. Puedes añadir ingredientes nuevos, eliminar algunos o eliminarlos todos. Ten siempre tu lista de la compra a mano. Te damos la posibilidad de hacer la compra a través de  la web  DelSuper  en el supermercado que prefieras en un solo click. Si pulsas en el botón hacer compra en Del Super te redireccionamos a su web con todos estos ingredientes seleccionados.";
        //Pasar texto de confirmacion de accion
        $view->action = "¿Estás seguro de que quieres borrar los productos de la lista de la compra?";

        return Response::forge($view);
    }

    public function get_delete_all()
    {
    	$recipes = Model_Recipe::get_recipes_current_week();

	    foreach ($recipes as $recipe)
	    {
	    	Log::error("ENTRO EN RECETAS!!!");
	    	foreach ($recipe->ingredients as $ingrediente)
		    {
		    	Log::error("INTENTO BORRAR INGREDIENTE!!! $ingrediente->id");
			    $ingrediente->delete();
		    }
	    }

	    Session::set_flash('success', "Se han borrado los ingredientes correctamente");
	    return Response::redirect_back();
    }

    public function post_delete_ingredients()
    {
    	$ingredients = Input::post('ingredients_ids');

    	foreach ($ingredients as $ingredient)
	    {
	    	$ingredient->delete();
	    }
    }
}