<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Luis
 * Date: 16/12/13
 * Time: 20:55
 * To change this template use File | Settings | File Templates.
 */

use Fuel\Core\DB;
use Fuel\Core\Response;
use \Parser\View;
use Auth\Auth;

class Controller_Menupersonalizado_Index extends \Controller_App{

    public function before(){

//        //Se cargan funciones de javascript especificas de esta funcionalidad
        Casset::js('menupersonalizado/index.js');

        parent::before();
    }

    public function get_index(){

        $view = View::forge('menupersonalizado/index.twig');

        //Titulo de la vista
        $view->title = "Menú Personalizado";

        //Pasar la leyenda para la info funcionamiento de la página
        $view->leyenda = "Una vez estudiado tu perfil te proponemos este menú semanal que se ajusta a tus necesidades. Elije entre las dos opciones que te proponemos de primero y segundo. Puedes acceder a las recetas de los platos pulsando sobre la lupa. ";

        $view->menu = $this->ws_menu_get();

        $view->auto_filter(false);

//        $view->Model_Recipe = new Model_Recipe();

        return Response::forge($view);
    }

    public function post_update(){

        $ids_recipes_selected = array();

        foreach (\Input::post('input') as $item){

            array_push($ids_recipes_selected,$item['recipe_id']);

            $conditions = array(
                'user_id' =>  \Session::get('user_id'),
                'year' => date('Y'),
                'week_year' => date("W"),
                'recipe_id' => $item['recipe_id'],
                'option' => $item['option'],
                'day_week' => $item['day_week'],
            );

            $query = Model_Recipe::find('all',array('where' => $conditions));

            if(!$query){
                Model_Recipe::forge($conditions)->save();
            }

        }

//        // Borramos las que no esten seleccionadas.
//        \Model_Recipe::recipes_current_week()->where('recipe_id','NOT IN', $ids_recipes_selected)->delete();
//


    }

}