<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Luis
 * Date: 16/12/13
 * Time: 20:55
 * To change this template use File | Settings | File Templates.
 */

use Fuel\Core\DB;
use Fuel\Core\Response;
use \Parser\View;
use Auth\Auth;

class Controller_Perfil_Index extends \Controller_App{


    public function before(){

        //Se cargan funciones de javascript especificas de esta funcionalidad
        Casset::js('perfil/index.js');
        parent::before();
    }

    /**
     *
     * Pantalla carga perfil
     *
     * @return Response
     */

    public function action_index(){

        $view = View::forge('perfil/index.twig');

        //Titulo de la vista
        $view->title = "Mi Perfil";

        //Pasar la leyenda para la info funcionamiento de la página
        $view->leyenda = "En esta pantalla puedes modificar tus datos personales. Generamos tu menú personalizado basándonos en estos datos. No te olvides de mantenerlo actualizado.";

        $view -> profile = $this->ws_profile_get();

        return Response::forge($view);
    }

    /**
     * Guardamos datos perfil.
     *
     * @return bool
     */
    public function post_update(){

        return $this->ws_profile_put(\Input::post('id'),\Input::post('inputs')) ? true : false;

    }


}