<?php
/**
 * Created by Dumitru Russu.
 * Date: 7/8/13
 * Time: 8:46 PM
 * To change this template use File | Settings | File Templates.
 */

namespace Sepa;


class Sepa {

    public function calculateBic($cuenta) {

        $c = substr($cuenta, 0, 4);

        $esiban = substr($cuenta,0,1);

        if($esiban=='E'){
            $c = substr($cuenta, 5, 4);
        }

        $codigo = \Model_Bic::query()->where('codigo',$c)->get_one();

        $bic = $codigo->BIC;

        return $bic;

    }

    public function calculateIban($cuenta) {

        $esiban = substr($cuenta,0,1);

        if($esiban=='E'){
            $cuenta = substr($cuenta, 5);
        }

        $secuencia = $cuenta."142800";

        $secuencia = str_replace(" ","",$secuencia);

        $resto = bcmod($secuencia ,97);

        $codigo = 98 - $resto;
        if(round($codigo)<10){
            $final = "ES0".round($codigo)." ".$cuenta;
        }else{
            $final = "ES".round($codigo)." ".$cuenta;
        }

        return $final;

    }

    public function export($id,$fichero) {

        $xmlGenerator = new Sepa_Xmlgenerator();

        foreach ($fichero as $_message ) {

            $message = new Sepa_Message();
            //set Message Group header Info
            $groupHeader = new Sepa_Header();

            $groupHeader->setMessageIdentification($_message['message_id']);
            $groupHeader->setInitiatingPartyName($_message['group_header']['company_name']);

            //set Message group header
            $message->setMessageGroupHeader($groupHeader);

            //set Message Payment Info

            foreach ($_message['payment_info'] as $SequenceType => $_paymentInfo ) {

                //set payment info
                $paymentInfo = new Sepa_Payment();
                $paymentInfo->setPaymentInformationIdentification($_paymentInfo['id']);
                $paymentInfo->setSequenceType($SequenceType);
                $paymentInfo->setCreditorAccountIBAN($_paymentInfo['creditor_iban']);
                $paymentInfo->setCreditorAccountBIC($_paymentInfo['creditor_bic']);
                $paymentInfo->setCreditorName($_paymentInfo['creditor_name']);
                $paymentInfo->setCreditorSchemeIdentification($_paymentInfo['scheme_identifier']);

                foreach ($_paymentInfo['transactions'] as $_transaction) {

                    //set payment info transactions
                    $transaction = new Sepa_Direct();
                    $transaction->setInstructionIdentification($_transaction['id']);

                    $transaction->setEndToEndIdentification($_transaction['endId']);
                    $transaction->setInstructedAmount($_transaction['amount']);
                    $transaction->setDebtorName($_transaction['company_name']);
                    $transaction->setDebitIBAN($_transaction['iban']);
                    $transaction->setDebitBIC($_transaction['bic']);
                    $transaction->setMandateIdentification($_transaction['umr']);
                    $transaction->setDateOfSignature($_transaction['mandate_sign_date']);
        		    $transaction->setCurrency('EUR');
                    $transaction->setDirectDebitInvoice($_transaction['invoice']);
                    //add Payment Info transactions
                    $paymentInfo->addDirectDebitTransaction($transaction);

                }
                //add Message Payment Info
                $message->addMessagePaymentInfo($paymentInfo);
            }
            //add Message To Xml File
            $xmlGenerator->addXmlMessage($message);
        }
        $xmlGenerator->saveXML($id);

    }
}
