/*------------------------------------------*/
/*---------------LOADING--------------------*/
/*--------------------------------------------*/

$(window).load(function() {
    // Animate loader off screen
    $(".cs-loader").fadeOut("slow");

    var height_screen =jQuery(window).height();   // return height of browser viewport
    $(".cs-loader").css("min-height", height_screen);


    // Control Checked inputs
    control_inputs_checked();

});


/*----------------------------------------------------*/
/*	Text imput effects
 /*----------------------------------------------------*/


(function() {
    // trim polyfill : https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/Trim
    if (!String.prototype.trim) {
        (function() {
            // Make sure we trim BOM and NBSP
            var rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;
            String.prototype.trim = function() {
                return this.replace(rtrim, '');
            };
        })();
    }

    [].slice.call( document.querySelectorAll( 'input.input__field' ) ).forEach( function( inputEl ) {
        // in case the input is already filled..
        if( inputEl.value.trim() !== '' ) {
            classie.add( inputEl.parentNode, 'input--filled' );
        }

        // events:
        inputEl.addEventListener( 'focus', onInputFocus );
        inputEl.addEventListener( 'blur', onInputBlur );
    } );

    function onInputFocus( ev ) {
        classie.add( ev.target.parentNode, 'input--filled' );
    }

    function onInputBlur( ev ) {
        if( ev.target.value.trim() === '' ) {
            classie.remove( ev.target.parentNode, 'input--filled' );
        }
    }
})();

/*----------------------------------------------------------------*/
/* SELECTORES ESPECIALES------------------------*/
/*-----------------------------------------------------------------*/
(function() {
    [].slice.call( document.querySelectorAll( 'select.cs-select' ) ).forEach( function(el) {
        new SelectFx(el);
    } );
})();

/*----------------------------------------------------*/
/*	TOOLTIPS
 /*----------------------------------------------------*/

//
$(function () {
    $('[data-toggle="tooltip-info"]').tooltip()
})


/**
 * Busca los input seleccionados.
 */

function control_inputs_checked() {

    $(':input:checked').map(function () {

        diff_input_checked(this);

    });
}

/**
 * Identidica el tipo de input seleccionado
 *
 * @param el
 */
function diff_input_checked(el) {

    var class_separate =  $(el).closest("form").attr('class').split(' ');

    var class_type = class_separate[class_separate.length-1];

    var type_separate = class_type.split('-');

    var type = type_separate[type_separate.length -1];

    switch (type) {

        case 'cross' :
        case 'checkmark' :
        case 'boxfill' :
        case 'diagonal' :
        case 'list' :

            print_checkbox_checked(el,type);

            break;

        case 'fill' :
        case 'circle' :
        case 'swirl' :

            print_radio_checked(el,type);

            break;

    }

}

/**
 * Marca los input de tipo checkbox
 *
 * @param el
 * @param type
 */
function print_checkbox_checked(el,type) {

    if( el.checked ) {
        draw( el, type );
    }
    else {
        reset( el );
    }
}

/**
 *
 * Marca los inputs de tipo radio.
 *
 * @param el
 * @param type
 */
function print_radio_checked(el,type) {
    resetRadio( el );
    draw( el, type );
}


