<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Luis
 * Date: 16/12/13
 * Time: 20:55
 * To change this template use File | Settings | File Templates.
 */

use Auth\Auth;
use Auth\UserDisabledException;
use Auth\UserNotFoundException;
use Auth\UserPasswordIncorrectException;
use Auth\UserUnverifiedException;
use Fuel\Core\Log;
use Fuel\Core\Response;
use Fuel\Core\Security;

class Controller_Login_Index extends Controller
{
    use \Trait_InutraliaWS;


    public function get_login()
    {
        // redirects if the user is logged
        // Si tiene el token auth esta logeado, en el before del controller APP controlamos el tiempo de exipacion de sessión.
        // En el Logut tenemos que destruir la sesión.

        if (\Session::get('token_auth') !== null) {

            $datos = \Config::load('empresa');
            Session::set('empresa', $datos);

            return Response::redirect('/dashboard');
        }

        $view = View::forge('login.twig');
        return $view;
    }

    public function post_login()
    {

        $datos = \Config::load('empresa');
        Session::set('empresa', $datos);

        $username = \Input::post('username');
        $password = \Input::post('password');

        // performs de validation
        if (!Security::check_token()) {
            Session::set_flash(
                'message:error',
                'Se perdio la ventana de autenticación, ha pasado demasiado tiempo
                inactivo, intentelo de nuevo.'
            );
            Response::redirect('auth/login');
            return null;
        }

        // seteamos el old input
        \Session::set_flash('login:username', \Input::post('username'));

        $return = (array)$this->ws_user($username,$password);

        if(!isset($return['status'])){

            Response::redirect('/dashboard');

            return null;

        }elseif ($return['status'] == "0"){

            \Session::set_flash(
                'message:error',
                $return['error'].' - Error al introducir el nombre de usuario o contraseña'
            );

        }else{

            \Session::set_flash(
                'message:error',
                'Para entrar en tu cuenta tienes que introducir tu email y contraseña.'
            );

        }

        Response::redirect('auth/login');
        return null;
    }

    public function get_logout()
    {
        Auth::logout();
        Response::redirect('/');
    }

    public function get_recover()
    {
        $view = View::forge('recover.twig');

        return Response::forge($view);
    }

    public function post_recover()
    {

        $usuario = Model_Auth_User::query()
            ->where('user', Input::Post('username', ''))
            ->related('group')
            ->get_one();

        if (isset($usuario) && $usuario->valid == 1) {
            $view = \View::forge("emails/pedidos/adminResend");

            $view->user = $usuario->user;
            $view->password = $usuario->password;

            $body = $view->render();

            $comu_session = Config::get('email');

            $error = false;
            //Preparar envio
            try {
                $transport = Swift_SmtpTransport::newInstance($comu_session['smtp'], $comu_session['port'], 'tls')
                    ->setUsername($comu_session['user'])->setPassword($comu_session['password']);

                $mailer = Swift_Mailer::newInstance($transport);

            } catch (Exception $e) {
                Log::error('Error Enviando correo1 - >' . $e->getMessage());
                $error = true;
            }//endCatch

            //Enviar Correo
            if (!$error) {
                try {
                    $message = Swift_Message::newInstance("Recuperación de contraseña")
                        ->setFrom(array($comu_session['emailfrom'] => $comu_session['emailfrom']))
                        ->setBody($body, 'text/html');

                    $message->setTo(array($comu_session['email'] => $comu_session['email']));

                    $mailer->send($message);

                } catch (Exception $e) {
                    Log::error('Error Enviando corre2 - >' . $e->getMessage());
                    $error = true;
                }//endCatch
            }//endIf

            if ($error) {
                Session::set_flash('msges.error', array('Error enviando correo.')); //Enviar Notifys!!!
            } else {
                Session::set_flash('msges.ok', array('Correos enviados correctamente.'));
            }//endIf

            Response::redirect('/');
        } else {
            //notificar Usuario no valido

            Response::redirect('recover');
        }
    }


}