<?php

namespace Auth;

use Orm\Model;

/**
 * SETI Consultyn S.L.
 * www.seticonsultyn.es
 *
 * Copyright(c) 2011-2013
 *
 * @author    SETI Consultyn S.L. <contacto@seticonsultyn.es>
 * @copyright 2011-2013 SETI Consultyn S.L. http://seticonsultyn.com/copyright.txt
 * @license   SETI Consultyn Software License <license.txt>
 * @link      http://seticonsultyn.es
 */

class Model_Auth_Group extends Model{

    protected static $_table_name = 'auth_groups';

    protected static $_primary_key = array('id');

    protected static $_has_many = array(
        'users' => array(
            'model_to' => 'Auth\\Model_Auth_User',
            'key_from' => 'id',
            'key_to' => 'group_id',
            'cascade_save' => true,
            'cascade_delete' => false
        ),
        'roles' => array(
            'model_to' => 'Auth\\Model_Auth_GroupRole',
            'key_from' => 'id',
            'key_to' => 'group_id',
            'cascade_save' => true,
            'cascade_delete' => false
        )
    );

    protected static $_observers = array(
        'Orm\\Observer_Typing' => array(
            'events' => array('before_save', 'after_save', 'after_load')
        ),
        'Orm\\Observer_CreatedAt' => array(
            'events' => array('before_insert'),
            'mysql_timestamp' => true,
            'property' => 'created_at',
        ),
        'Orm\\Observer_UpdatedAt' => array(
            'events' => array('before_save'),
            'mysql_timestamp' => true,
            'property' => 'updated_at',
        ),
    );
}