<?php
/**
 * Created by JetBrains PhpStorm.
 * User: Luis
 * Date: 16/12/13
 * Time: 20:55
 * To change this template use File | Settings | File Templates.
 */

use Fuel\Core\DB;
use Fuel\Core\Response;
use \Parser\View;
use Auth\Auth;

class Controller_Perfil_Index extends \Controller_App{

    //Variable para guardar las migas de pan que van a aparecer en las vistas
    private $_bc = array();

    //Array con los elementos del menu que se deben marcar con la clase "active" para que esten seleccionados en el menu.
    private $_option_menu=array('Mi Perfil');

    public function before(){

        //Se cargan funciones de javascript especificas de esta funcionalidad
        Casset::js('perfil/index.js');

        //Se marca la navegación en forma de migas de pan. Cada miga de pan la forman dos variables:
        //  ds  : String a mostrar
        //  url : url del enlace en modo absoluto
        $this->_bc[] = array('ds'=>'Inicio','url'=>'/dashboard');

        parent::before();
    }

    /**
     *
     * Pantalla carga perfil
     *
     * @return Response
     */

    public function action_index(){

        $view = View::forge('perfil/index.twig');

        //Titulo de la vista
        $view->title = "Mi Perfil";

        //Paso de las migas de pan a la vista
        $view->bc = $this->_bc;

        //Paso de las opciones de menu que deben aparecer seleccionadas
        $view->option_menu = $this->_option_menu;

        //Pasar la leyenda para la info funcionamiento de la página
        $view->leyenda = "En esta pantalla puedes modificar tus datos personales. Generamos tu menú personalizado basándonos en estos datos. No te olvides de mantenerlo actualizado.";

        $view -> profile = $this->ws_profile_get();

        return Response::forge($view);
    }

    /**
     * Guardamos datos perfil.
     *
     * @return bool
     */
    public function post_update(){

        return $this->ws_profile_put(\Input::post('id'),\Input::post('inputs')) ? true : false;

    }


}